<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateModulesHierarchiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DB_CONNECTION'))->create('modules_hierarchies', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parent_module_id');
            $table->unsignedBigInteger('child_module_id');
            $table->timestamps();
            $table->foreign('parent_module_id')->references('id')->on(env('DB_DATABASE').'.system_modules');
            $table->foreign('child_module_id')->references('id')->on(env('DB_DATABASE').'.system_modules');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DB_CONNECTION'))->dropIfExists('modules_hierarchies');
    }
}
