<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnCurrentRoleIdToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('current_role_id')->nullable()->after('id');
            $table->foreign('current_role_id')->references('id')->on(env('DB_DATABASE') . '.roles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign('users_current_role_id_foreign');
            $table->dropIndex('users_current_role_id_foreign');
            $table->dropColumn('current_role_id');
        });
    }
}
