<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDescriptorColumnsToFeatures extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('features', function (Blueprint $table) {
            $table->string('title')->after('name')->nullable();
            $table->string('description')->after('title')->nullable();
            $table->unsignedBigInteger('system_id')->after('description')->nullable();
            $table->integer('type')->after('system_id')->default(1)->nullable()->comment('1 = standard, 2 = add-on');
            $table->foreign('system_id')->references('id')->on(env('DB_DATABASE'). '.systems');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('features', function (Blueprint $table) {
            $table->dropColumn('title');
            $table->dropColumn('description');
            $table->dropColumn('type');
            $table->dropForeign('features_system_id_foreign');
            $table->dropColumn('system_id');
        });
    }
}
