<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Suiterus\Dms\Models\Configuration\ConfigEmail;

class ModifyEmailColumnInConfigEmail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        ConfigEmail::truncate();
        Schema::connection(env('DMS_DB_CONNECTION'))->table('config_email', function (Blueprint $table) {
            $table->longText('mail_from_name')->after('port');
            $table->longText('mailer')->change();
            $table->longText('email')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        ConfigEmail::truncate();
        Schema::connection(env('DMS_DB_CONNECTION'))->table('config_email', function (Blueprint $table) {
            $table->dropColumn('mail_from_name');
            $table->string('mailer')->change();
            $table->string('email')->change();
        });
    }
}
