<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnRoleSystemModuleIdToRoleHasPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DB_CONNECTION'))->table('role_has_permissions', function (Blueprint $table) {
            $table->unsignedBigInteger('role_system_module_id')->nullable()->after('role_id');
            $table->foreign('role_system_module_id')->references('id')->on(env('DB_DATABASE').'.role_has_system_modules')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DB_CONNECTION'))->table('role_has_permissions', function (Blueprint $table) {
            $table->dropForeign(['role_system_module_id']);
            $table->dropColumn('role_system_module_id');
        });
    }
}
