<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRoleHasSystemModulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DB_CONNECTION'))->create('role_has_system_modules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('role_id');
            $table->unsignedBigInteger('system_module_id');
            $table->timestamps();
            $table->foreign('role_id')->references('id')->on(env('DB_DATABASE').'.roles');
            $table->foreign('system_module_id')->references('id')->on(env('DB_DATABASE').'.system_modules');
            $table->unique(['role_id', 'system_module_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DB_CONNECTION'))->dropIfExists('role_has_system_modules');
    }
}
