<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnSystemModuleIdToPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('DB_CONNECTION'))->table('permissions', function (Blueprint $table) {
            $table->unsignedBigInteger('system_module_id')->nullable()->after('guard_name');
            $table->string('display_name')->nullable()->after('name');
            $table->foreign('system_module_id')->references('id')->on(env('DB_DATABASE').'.system_modules');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('DB_CONNECTION'))->table('permissions', function (Blueprint $table) {
            $table->dropForeign(['system_module_id']);
            $table->dropColumn('system_module_id');
        });
    }
}
