<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Default Cloud Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Many applications store files both locally and in the cloud. For this
    | reason, you may specify a default "cloud" driver here. This driver
    | will be bound as the Cloud disk implementation in the container.
    |
    */

    'cloud' => env('FILESYSTEM_CLOUD', 's3'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
        ],

        'converted_office' => [
            'driver' => 'local',
            'root' => storage_path('app/convert/office'),
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL').'/storage',
            'visibility' => 'public',
        ],

        'personal' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_PERSONAL') ?? storage_path('app/dms/personal'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'private' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_PRIVATE') ?? storage_path('app/dms/private'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'shared' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_SHARED') ?? storage_path('app/dms/public'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'contract_indexes' => [
            'driver' => 'local',
            'host' => '',
            'username' => '',
            'password' => '',
            'port' => '',
            'root' => storage_path('app/dms/contract_indexes'),
            'url' => env('APP_URL').'/storage',
        ],

        'attachment' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_ATTACHMENT') ?? storage_path('app/other-attachment'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'supplementary_requirements' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_SUPPLEMENTARY_ATTACHMENT') ?? storage_path('app/supplementary-attachment'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'e_signature' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_SIGNATURE') ?? storage_path('app/e-signature'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'report_template' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_GENERATED_REPORTS') ?? storage_path('app/public/report-template'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'generated_reports' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_GENERATED_REPORTS') ?? storage_path('app/generated-reports'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'tmp_encrypt_document' => [
            'driver' => 'local',
            'host' => '',
            'username' => '',
            'password' => '',
            'port' => '',
            'root' => storage_path('app/tmp-encrypt-document'),
            'url' => env('APP_URL').'/storage',
        ],

        'payroll' => [
            'driver' => 'local',
            'root' => storage_path('app/payroll'),
            'url' => env('APP_URL').'/storage',
        ],

        'employee' => [
            'driver' => 'local',
            'root'  => storage_path('app/employees'),
            'url'   => env('APP_URL') . '/storage'
        ],

        'mentorship_attachment' => [
            'driver' => 'local',
            'root'  => storage_path('app/mentorship-attachment'),
            'url'   => env('APP_URL') . '/storage'
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
            'endpoint' => env('AWS_ENDPOINT'),
        ],

        'profile' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_PROFILE') ?? storage_path('app/profile'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'leave_form' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_LEAVE_FORM') ?? storage_path('app/leave-forms'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'appointment_form' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_APPOINTMENT_FORM') ?? storage_path('app/appointment_form'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'saln_attachment' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_SALN_ATTACHMENT') ?? storage_path('app/saln-attachment'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'employee_type_history' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_EMPLOYEE_TYPE_HISTORY') ?? storage_path('app/appointment_form/employee-type-history'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'promotion_requirements' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_PROMOTION_REQUIREMENTS') ?? storage_path('app/promotion-attachments'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'promotion_appointment_form' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_PROMOTION_FORM') ?? storage_path('app/promotion-appointment-form'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'employee_proof_attachment' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_EMPLOYEE_PROOF_ATTACHMENT') ?? storage_path('app/employee-proof-attachment'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

        'absenteeism_reports' => [
            'driver' => env('FILE_SYSTEM_DRIVER') ?? 'local',
            'host' => env('FILE_SYSTEM_HOST') ?? '',
            'username' => env('FILE_SYSTEM_USERNAME') ?? '',
            'password' => env('FILE_SYSTEM_PASSWORD') ?? '',
            'port' => env('FILE_SYSTEM_PORT') ?? '',
            'root' => env('FILE_SYSTEM_ROOT_ABSENTEEISM_REPORTS') ?? storage_path('app/absenteeism-reports'),
            'url' => env('FILE_SYSTEM_URL') ?? env('APP_URL').'/storage',
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
