<?php

use Illuminate\Support\Str;

return [

    /*
    |--------------------------------------------------------------------------
    | Default Database Connection Name
    |--------------------------------------------------------------------------
    |
    | Here you may specify which of the database connections below you wish
    | to use as your default connection for all database work. Of course
    | you may use many connections at once using the Database library.
    |
    */

    'default' => env('DB_CONNECTION', 'mysql'),

    /*
    |--------------------------------------------------------------------------
    | Database Connections
    |--------------------------------------------------------------------------
    |
    | Here are each of the database connections setup for your application.
    | Of course, examples of configuring each database platform that is
    | supported by Laravel is shown below to make development simple.
    |
    |
    | All database work in Laravel is done through the PHP PDO facilities
    | so make sure you have the driver for your particular database of
    | choice installed on your machine before you begin development.
    |
    */

    'connections' => [

        'sqlite' => [
            'driver' => 'sqlite',
            'url' => env('DATABASE_URL'),
            'database' => env('DB_DATABASE', database_path('database.sqlite')),
            'prefix' => '',
            'foreign_key_constraints' => env('DB_FOREIGN_KEYS', true),
        ],

        'mysql' => [
            'driver' => 'mysql',
            'url' => env('DATABASE_URL'),
            'host' => env('DB_HOST', '127.0.0.1'),
            'port' => env('DB_PORT', '3306'),
            'database' => env('DB_DATABASE', 'forge'),
            'username' => env('DB_USERNAME', 'forge'),
            'password' => env('DB_PASSWORD', ''),
            'unix_socket' => env('DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'modes' => [
                'STRICT_TRANS_TABLES',
                'NO_ZERO_IN_DATE',
                'NO_ZERO_DATE'
            ],
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'fdg_db' => [
            'driver' => 'mysql',
            'url' => env('FDG_DATABASE_URL'),
            'host' => env('FDG_DB_HOST', '127.0.0.1'),
            'port' => env('FDG_DB_PORT', '3306'),
            'database' => env('FDG_DB_DATABASE', 'forge'),
            'username' => env('FDG_DB_USERNAME', 'forge'),
            'password' => env('FDG_DB_PASSWORD', ''),
            'unix_socket' => env('FDG_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'dms_db' => [
            'driver' => 'mysql',
            'url' => env('DMS_DATABASE_URL'),
            'host' => env('DMS_DB_HOST', '127.0.0.1'),
            'port' => env('DMS_DB_PORT', '3306'),
            'database' => env('DMS_DB_DATABASE', 'forge'),
            'username' => env('DMS_DB_USERNAME', 'forge'),
            'password' => env('DMS_DB_PASSWORD', ''),
            'unix_socket' => env('DMS_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'adg_db' => [
            'driver' => 'mysql',
            'url' => env('ADG_DATABASE_URL'),
            'host' => env('ADG_DB_HOST', '127.0.0.1'),
            'port' => env('ADG_DB_PORT', '3306'),
            'database' => env('ADG_DB_DATABASE', 'forge'),
            'username' => env('ADG_DB_USERNAME', 'forge'),
            'password' => env('ADG_DB_PASSWORD', ''),
            'unix_socket' => env('ADG_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => false,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'pdg_db' => [
            'driver' => 'mysql',
            'url' => env('PDG_DATABASE_URL'),
            'host' => env('PDG_DB_HOST', '127.0.0.1'),
            'port' => env('PDG_DB_PORT', '3306'),
            'database' => env('PDG_DB_DATABASE', 'forge'),
            'username' => env('PDG_DB_USERNAME', 'forge'),
            'password' => env('PDG_DB_PASSWORD', ''),
            'unix_socket' => env('PDG_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'hrjp_db' => [
            'driver' => 'mysql',
            'url' => env('HRJP_DATABASE_URL'),
            'host' => env('HRJP_DB_HOST', '127.0.0.1'),
            'port' => env('HRJP_DB_PORT', '3306'),
            'database' => env('HRJP_DB_DATABASE', 'forge'),
            'username' => env('HRJP_DB_USERNAME', 'forge'),
            'password' => env('HRJP_DB_PASSWORD', ''),
            'unix_socket' => env('HRJP_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'wordpress_learning_db' => [
            'driver' => 'mysql',
            'url' => env('WP_LEARNING_DATABASE_URL'),
            'host' => env('WP_LEARNING_DB_HOST', '127.0.0.1'),
            'port' => env('WP_LEARNING_DB_PORT', '3306'),
            'database' => env('WP_LEARNING_DB_DATABASE', 'forge'),
            'username' => env('WP_LEARNING_DB_USERNAME', 'forge'),
            'password' => env('WP_LEARNING_DB_PASSWORD', ''),
            'unix_socket' => env('WP_LEARNING_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'wordpress_telemed_db' => [
            'driver' => 'mysql',
            'url' => env('WP_TELEMED_DATABASE_URL'),
            'host' => env('WP_TELEMED_DB_HOST', '127.0.0.1'),
            'port' => env('WP_TELEMED_DB_PORT', '3306'),
            'database' => env('WP_TELEMED_DB_DATABASE', 'forge'),
            'username' => env('WP_TELEMED_DB_USERNAME', 'forge'),
            'password' => env('WP_TELEMED_DB_PASSWORD', ''),
            'unix_socket' => env('WP_TELEMED_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'wordpress_test_db' => [
            'driver' => 'mysql',
            'url' => env('WP_TEST_DATABASE_URL'),
            'host' => env('WP_TEST_DB_HOST', '127.0.0.1'),
            'port' => env('WP_TEST_DB_PORT', '3306'),
            'database' => env('WP_TEST_DB_DATABASE', 'forge'),
            'username' => env('WP_TEST_DB_USERNAME', 'forge'),
            'password' => env('WP_TEST_DB_PASSWORD', ''),
            'unix_socket' => env('WP_TEST_DB_SOCKET', ''),
            'charset' => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix' => '',
            'prefix_indexes' => true,
            'strict' => true,
            'engine' => 'InnoDB',
            'options' => extension_loaded('pdo_mysql') ? array_filter([
                PDO::MYSQL_ATTR_SSL_CA => env('MYSQL_ATTR_SSL_CA'),
            ]) : [],
        ],

        'pgsql' => [
            'driver' => 'pgsql',
            'url' => env('DATABASE_URL'),
            'host' => env('DB_HOST', '127.0.0.1'),
            'port' => env('DB_PORT', '5432'),
            'database' => env('DB_DATABASE', 'forge'),
            'username' => env('DB_USERNAME', 'forge'),
            'password' => env('DB_PASSWORD', ''),
            'charset' => 'utf8',
            'prefix' => '',
            'prefix_indexes' => true,
            'schema' => 'public',
            'sslmode' => 'prefer',
        ],

        'sqlsrv' => [
            'driver' => 'sqlsrv',
            'url' => env('DATABASE_URL'),
            'host' => env('DB_HOST', 'localhost'),
            'port' => env('DB_PORT', '1433'),
            'database' => env('DB_DATABASE', 'forge'),
            'username' => env('DB_USERNAME', 'forge'),
            'password' => env('DB_PASSWORD', ''),
            'charset' => 'utf8',
            'prefix' => '',
            'prefix_indexes' => true,
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Migration Repository Table
    |--------------------------------------------------------------------------
    |
    | This table keeps track of all the migrations that have already run for
    | your application. Using this information, we can determine which of
    | the migrations on disk haven't actually been run in the database.
    |
    */

    'migrations' => 'migrations',

    /*
    |--------------------------------------------------------------------------
    | Redis Databases
    |--------------------------------------------------------------------------
    |
    | Redis is an open source, fast, and advanced key-value store that also
    | provides a richer body of commands than a typical key-value system
    | such as APC or Memcached. Laravel makes it easy to dig right in.
    |
    */

    'redis' => [

        'client' => env('REDIS_CLIENT', 'predis'),

        'options' => [
            'cluster' => env('REDIS_CLUSTER', 'predis'),
            'prefix' => env('REDIS_PREFIX', null),
        ],

        'default' => [
            'url' => env('REDIS_URL'),
            'host' => env('REDIS_HOST', '127.0.0.1'),
            'password' => env('REDIS_PASSWORD', null),
            'port' => env('REDIS_PORT', '6379'),
            'database' => env('REDIS_DB', '0'),
        ],

        'cache' => [
            'url' => env('REDIS_URL'),
            'host' => env('REDIS_HOST', '127.0.0.1'),
            'password' => env('REDIS_PASSWORD', null),
            'port' => env('REDIS_PORT', '6379'),
            'database' => env('REDIS_CACHE_DB', '1'),
        ],

    ],

];
