require("dotenv").config();
const { join } = require("path");
const { copySync, removeSync } = require("fs-extra");
const { gitDescribeSync } = require("git-describe");
process.env.VUE_APP_GIT_HASH = gitDescribeSync().hash;

module.exports = {
    ssr: false,
    srcDir: __dirname,
    env: {
        version: process.env.VUE_APP_GIT_HASH,
        apiUrl: process.env.API_URL || process.env.APP_URL + "/api",
        appName: process.env.APP_NAME || "API",
        appLocale: process.env.APP_LOCALE || "en",
        githubAuth: !!process.env.GITHUB_CLIENT_ID,
    },
    head: {
        title: process.env.APP_NAME,
        titleTemplate: "%s " + process.env.VUE_APP_GIT_HASH,
        meta: [
          { charset: "utf-8" }, 
          { name: "viewport", content: "width=device-width, initial-scale=1" }, 
          { hid: "description", name: "description", content: "API" }
        ],
        link: [{ rel: "icon", type: "image/x-icon", href: "_blank" }],
    },
    loading: { color: "#007bff" },
    css: [{ src: "~assets/sass/app.css" }],
    modules: ["@nuxtjs/router"],
    build: {
        extractCSS: true,
    },
    hooks: {
        generate: {
            done(generator) {
                // Copy dist files to public/_nuxt
                if (generator.nuxt.options.dev === false && generator.nuxt.options.mode === "spa") {
                    const publicDir = join(generator.nuxt.options.rootDir, "public", "_nuxt");
                    removeSync(publicDir);
                    copySync(join(generator.nuxt.options.generate.dir, "_nuxt"), publicDir);
                    copySync(join(generator.nuxt.options.generate.dir, "200.html"), join(publicDir, "index.html"));
                    removeSync(generator.nuxt.options.generate.dir);
                }
            },
        },
    },
};