<?php

namespace App\Services\AccountSyncing;

class WpAccountSyncService
{
    /**
     * The function syncs user accounts to multiple systems based on the configuration and returns the
     * created accounts.
     *
     * @param array data An array containing the data to be synced to WordPress.
     *
     * @return an array of accounts that have been created in the specified systems.
     */
    public static function syncAccountsToWordpress(array $data)
    {
        $systems = config('account-syncing.systems');
        $accounts = [];

        foreach ($systems as $system) {
            if ($system['is_sync']) {
                $userModel = new $system['class_name'];
                $accounts[] = $userModel->updateOrCreate(
                    [
                        'user_email' => $data['user_email']
                    ],
                    $data
                );
            };
        }

        return $accounts;
    }
}
