<?php

namespace App\Providers;

use App\Ldap\Listeners\AdSync;
use App\Models\User;
use Illuminate\Support\Facades\Event;
use LdapRecord\Container;
use Illuminate\Support\ServiceProvider;
use LdapRecord\Laravel\Events\Import\Saved;

class LdapEventServiceProvider extends ServiceProvider
{
    /**
     * The LDAP event listener mappings for the application.
     *
     * @return array
     */
    protected $listen = [
        Saved::class => [
            AdSync::class
        ],
    ];

    /**
     * Register the application LDAP event listeners.
     *
     * @return void
     */
    public function boot()
    {
        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }
}
