<?php

namespace App\Providers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use Suiterus\Dms\Validator\MimeTypeSniffer;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Validator::extend('mimesniffer', MimeTypeSniffer::class);
        //if ($this->app->runningUnitTests()) {
            Schema::defaultStringLength(191);
       // }
        Http::macro('zktecoFlask', function () {
            return Http::baseUrl(env('FLASK_URL'));
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
