<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class JobPortalNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $message;
    protected $receiverName;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($message, $receiverName)
    {
        $this->message = $message;
        $this->receiverName = $receiverName;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $jpURL = env('JOB_PORTAL_URL');
        // move this url to env
        return (new MailMessage)
                    ->subject('NKTI Job Portal Notification')
                    ->greeting('Hi, '. $this->receiverName)
                    ->line($this->message)
                    ->action('Job Portal', $jpURL)
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
