<?php

namespace App\Models\WpAccountSyncing;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WordpressTestUser extends Model
{
    use HasFactory;

    protected $connection = 'wordpress_test_db';

    protected $fillable = [
        'user_login',
        'user_pass',
        'user_nicename',
        'user_email',
        'user_url',
        'user_registered',
        'user_activation_key',
        'user_status',
        'display_name'
    ];

    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        $this->table = env('WP_TEST_DB_DATABASE') . '.' . env('WP_TEST_TABLE');
        $this->connection = env('WP_TEST_DB_CONNECTION');
        parent::__construct($attributes);
    }
}
