<?php

namespace App\Models\WpAccountSyncing;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LearningManagementUser extends Model
{
    use HasFactory;

    protected $connection = 'wordpress_learning_db';

    protected $fillable = [
        'ID',
        'user_login',
        'user_pass',
        'user_nicename',
        'user_email',
        'user_url',
        'user_registered',
        'user_activation_key',
        'user_status',
        'display_name'
    ];

    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        $this->table = env('WP_LEARNING_DB_DATABASE') . '.' . env('WP_LEARNING_TABLE');
        $this->connection = env('WP_LEARNING_DB_CONNECTION');
        parent::__construct($attributes);
    }
}
