<?php

namespace App\Models\Systems;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationTo extends Model
{
    use HasFactory;

    protected $connection = 'mysql';

    protected $fillable = [
        'user_id',
        'status'
    ];

    protected $with = [
        'user'
    ];

    //user 
    public function user(){
        return $this->belongsTo('App\Models\User');
    }

    //notification
    public function notification(){
        return $this->belongsTo('App\Models\Systems\Notification');
    }

}
