<?php

namespace App\Models\Systems;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{

    use HasFactory;

    protected $connection = 'mysql';

    protected $fillable = [
        'title',
        'message',
        'type',
        'sender_id',
        'receiver_id'
    ];

    protected $with = [
        'sender',
        'receiver'
    ];

    public function sender(){
        return $this->belongsTo(User::class, 'sender_id', 'id');
    }

    public function receiver(){
        return $this->belongsTo(User::class, 'receiver_id', 'id');
    }

}
