<?php

namespace App\Models\Profile;

use App\Models\AccessManagement\GroupManagement\Role;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProfileBasicInfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'birthday',
        'gender',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DB_DATABASE') . '.profile_basic_infos';
        $this->connection = env('DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function name()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
