<?php

namespace App\Models;

use App\Models\AccessManagement\GroupManagement\SystemModule;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModulesHierarchy extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_module_id',
        'child_module_id'
    ];

    public function parent()
    {
        return $this->belongsTo(SystemModule::class, 'parent_module_id');
    }

    public function child()
    {
        return $this->belongsTo(SystemModule::class, 'child_module_id');
    }
}
