<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\System;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\RoleHasSystemModule;
use App\Models\ModulesHierarchy;

class SystemModule extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.system_modules';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'name',
        'display_name',
        'system_id'
    ];

    protected $with = [
        'permission'
    ];

    public function system(){
        return $this->belongsTo(System::class, 'system_id', 'id');
    }

    public function permission(){
        return $this->hasMany(Permission::class, 'system_module_id', 'id');
    }

    public function roleHasSystemModule(){
        return $this->hasMany(RoleHasSystemModule::class, 'system_module_id', 'id');
    }

    public function parents(){
        return $this->hasMany(ModulesHierarchy::class, 'child_module_id', 'id');
    }

    public function children(){
        return $this->hasMany(ModulesHierarchy::class, 'parent_module_id', 'id');
    }
}
