<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\SystemModule;
use App\Models\AccessManagement\GroupManagement\RoleHasSystem;

class System extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.systems';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'name',
    ];

    public function roleHasSystem(){
        return $this->hasMany(RoleHasSystem::class, 'system_id', 'id');
    }

    public function systemModule(){
        return $this->hasMany(SystemModule::class, 'system_id', 'id');
    }
}
