<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubRole extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_role_id',
        'sub_role_id',
    ];

    protected $with =[
        'parentRole',
        'subRole'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('DB_DATABASE') . '.sub_roles';
        parent::__construct($attributes);
    }

    public function parentRole()
    {
        return $this -> belongsTo(Role::class, 'parent_role_id', 'id');
    }

    public function subRole()
    {
        return $this -> belongsTo(Role::class, 'sub_role_id', 'id');
    }
}
