<?php

namespace App\Models\AccessManagement\GroupManagement;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RoleLeader extends Model
{
    use HasFactory;

    public function __construct(array $attributes = [])
    {
        $this->table = env('DB_DATABASE') . '.role_leaders';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'role_id',
        'user_id'
    ];

    protected $with = [
        'user',
        'role'
    ];

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id', 'id')->without([
            'roleLeader',
            'sectionAccess',
            'member'
        ])->with([
            'roleHasSystem' => function ($query) {
                $query->without(['role']);
            }
        ]);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->select('id', 'name')->without([
            'roles',
            'permissions',
            'supervisor',
            'employeeMetaInfo',
            'storage',
            'exitInterview',
        ]);
    }
}
