<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\SystemModule;
use App\Models\AccessManagement\GroupManagement\RoleHasPermission;

class RoleHasSystemModule extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.role_has_system_modules';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'role_id',
        'system_module_id'
    ];

    protected $with = [
        'roleHasPermission'
    ];

    public function role(){
        return $this->belongsTo(Role::class, 'role_id', 'id');
    }

    public function systemModule(){
        return $this->belongsTo(SystemModule::class, 'system_module_id', 'id');
    }

    public function roleHasPermission(){
        return $this->hasMany(RoleHasPermission::class, 'role_system_module_id', 'id');
    }
}
