<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\System;

class RoleHasSystem extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.role_has_systems';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'system_id',
        'role_id'
    ];

    protected $with = [
        'role',
        'system'
    ];

    public function role(){
        return $this->belongsTo(Role::class, 'role_id', 'id');
    }

    public function system(){
        return $this->belongsTo(System::class, 'system_id', 'id');
    }
}
