<?php

namespace App\Models\AccessManagement\GroupManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\RoleHasSystemModule;

class RoleHasPermission extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.role_has_permissions';
        parent::__construct($attributes);
    }

    public $timestamps = false;

    protected $fillable = [
        'permission_id',
        'role_id',
        'role_system_module_id'
    ];

    public function role(){
        return $this->belongsTo(Role::class, 'role_id', 'id');
    }

    public function permission(){
        return $this->belongsTo(Permission::class, 'permission_id', 'id');
    }

    public function roleHasSystemModule(){
        return $this->belongsTo(RoleHasSystemModule::class, 'role_system_module_id', 'id');
    }
}
