<?php

namespace App\Models\AccessManagement\GroupManagement;

use App\Traits\RemoveRoleSystemText;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use Suiterus\Dms\Models\Files\FileAccess;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\RoleLeader;
use App\Models\AccessManagement\GroupManagement\ModelHasRole;
use App\Models\AccessManagement\GroupManagement\RoleHasSystem;
use App\Models\AccessManagement\GroupManagement\RoleHasPermission;
use App\Models\AccessManagement\GroupManagement\RoleHasSystemModule;
use LaravelFeature\Featurable\Featurable;
use LaravelFeature\Featurable\FeaturableInterface;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;

class Role extends Model implements FeaturableInterface
{

    use HasFactory, RemoveRoleSystemText, SoftDeletes, Featurable;

    public function __construct(array $attributes = [])
    {
        $this->table = env('DB_DATABASE') . '.roles';
        parent::__construct($attributes);
    }

    protected $removeRoleSystemText = [
        'name'
    ];

    protected $fillable = [
        'name',
        'guard_name'
    ];

    protected $with = [
        'roleLeader',
        'sectionAccess',
        'member'
    ];

    public function sectionAccess()
    {
        return $this->hasMany(SectionAccess::class, 'group_id', 'id');
    }

    public function fileAccess()
    {
        return $this->hasMany(FileAccess::class, 'group_id', 'id');
    }

    public function roleLeader()
    {
        return $this->hasOne(RoleLeader::class, 'role_id', 'id');
    }

    public function modelHasRole()
    {
        return $this->hasMany(ModelHasRole::class, 'role_id', 'id');
    }

    public function member()
    {
        return $this->hasMany(ModelHasRole::class, 'role_id', 'id')->take(5);
    }

    public function roleHasPermission()
    {
        return $this->hasMany(RoleHasPermission::class, 'role_id', 'id');
    }

    public function roleHasSystem()
    {
        return $this->hasOne(RoleHasSystem::class, 'role_id', 'id');
    }

    public function roleHasSystemModule()
    {
        return $this->hasMany(RoleHasSystemModule::class, 'role_id', 'id');
    }

    public function subRoles()
    {
        return $this->hasMany(SubRole::class, 'parent_role_id', 'id');
    }

    public function leaveEligibleGroup()
    {
        return $this->hasMany(LeaveType::class, 'group_id', 'id');
    }
}
