<?php

namespace App\Models\AccessManagement\GroupManagement;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\AccessManagement\GroupManagement\SystemModule;
use App\Models\AccessManagement\GroupManagement\RoleHasPermission;

class Permission extends Model
{
    use HasFactory;

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.permissions';
        parent::__construct($attributes);
    }

    protected $fillable = [
        'name',
        'display_name',
        'guard_name',
        'system_module_id'
    ];

    public function systemModule(){
        return $this->belongsTo(SystemModule::class, 'system_module_id', 'id');
    }

    public function roleHasPermission(){
        return $this->hasMany(RoleHasPermission::class, 'permission_id', 'id');
    }
    
}
