<?php

namespace App\Models\AccessManagement\GroupManagement;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\AccessManagement\GroupManagement\Role;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ModelHasRole extends Model
{
    use HasFactory;

    public $timestamps = false;
    
    protected $fillable = [
        'role_id', 
        'model_type',
        'model_id'
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('DB_DATABASE') . '.model_has_roles';
        parent::__construct($attributes);
    }

    public function role(){
        return $this->belongsTo(Role::class, 'role_id', 'id')->without([
            'roleLeader',
            'sectionAccess',
            'member'
        ]);
    }

    public function user(){
        return $this->belongsTo(User::class, 'model_id', 'id')->select('id', 'name')->without(['roles', 'permissions', 'supervisor', 'employeeMetaInfo', 'storage']);
    }
}
