<?php

namespace App\Ldap\Listeners;

use App\Models\User;
use Illuminate\Support\Carbon;
use LdapRecord\Laravel\Events\Import\Saved;

class AdSync
{

    public function handle(Saved $event)
    {
        $userObject = User::where('id', $event->eloquent->id);

        $user = $userObject->first();

        $user->givePermissionTo('can login');

        $user->assignRole('user');

        $user->email_verified_at = Carbon::now();

        $user->save();
    }
}
