<?php

namespace App\Jobs;

use App\Enums\Payroll\PayrollType;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Suiterus\Adg\Controllers\Payroll\Generator\PayrollGenerator;
use Suiterus\Adg\Controllers\Payroll\Generator\PrivatePayrollGenerator;
use Suiterus\Adg\Controllers\Payroll\Generator\PublicPayrollGenerator;
use Suiterus\Adg\Models\Payroll\Payroll;
use Suiterus\Adg\Models\Payroll\PayrollEmployee;
use Suiterus\Adg\Models\Salary\UserSalary;

class GeneratePayroll implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $payroll;
    protected $sector;
    protected $user;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($payroll, $sector, $user)
    {
        $this->payroll = $payroll;
        $this->sector = $sector;
        $this->user = $user;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $payroll = Payroll::where('id', $this->payroll->id);

        $payrollCollection = $payroll->first();

        $forReview = 1;
        $ongoing = 4;
        $pending = 5;

        if ($payrollCollection->status == $pending) {
            $payroll->update([
                'status' => $ongoing
            ]);
        }

        $generator = $this->sector == 'public' ? new PublicPayrollGenerator($this->payroll) : new PrivatePayrollGenerator($this->payroll);

        if($this->payroll->type == PayrollType::WEEKLY){
            $payslips = $generator->weekly($this->user);
        } else if($this->payroll->type == PayrollType::SEMIMONTHLY) {
            $payslips = $generator->semi_monthly($this->user, $this->payroll->period_start, $this->payroll->period_end);
        } else {
            $payslips = $generator->monthly($this->user, $this->payroll->period_start, $this->payroll->period_end);
        }

        $generatedCount = 0;

        $generatedCount = PayrollEmployee::where('payroll_id', $this->payroll->id)->count();

        if ($generatedCount >= $payrollCollection->payroll_employee_total_count) {
            $payroll->update([
                'payroll_employee_generated_count' => $generatedCount,
                'status' => $forReview
            ]);
            return $payslips;
        }

        $payroll->update([
            'payroll_employee_generated_count' => $generatedCount
        ]);

    }
}
