<?php

namespace App\Http\Requests\SwitchRoleRequest;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;

class UpdateRequest extends FormRequest
{
    public function authorize()
    {
        $role = Role::find($this->route('role_id'));

        if (!$role) {
            return false;
        }

        return Auth::user()->hasRole($role);
    }

    public function rules()
    {
        return [
            'role_id' => 'required|exists:' . env('DB_CONNECTION') . '.roles,id',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'role_id' => $this->route('role_id'),
        ]);
    }
}
