<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'id' => 'sometimes|required|exists:' . env('ADG_DB_CONNECTION') . '.' . 'saln_reports,id',
            'attachment' => 'max:10240|mimes:pdf' ,
            'user_id' => 'required|integer'
        ];
    }
}