<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Exceptions\UnauthorizedException;


class HeadEmployee
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {   
        
        $user = User::where('id', Auth::user()->id)->first();
        //check if user is admin
        if($user->roles->whereIn('name',['Super Admin','Admin','Developer'])->isNotEmpty()) {
            return $next($request);
        }

        if ($user->employeeMetaInfo == null) {
            return abort(403);
        }
        
        $group = $user->employeeMetaInfo->position->rosterGroup->name;

        if($group != 'Head Employees') {
            return abort(403);
        }

        return $next($request);
    }
}
