<?php

namespace App\Http\Middleware;

use App\Enums\Dms\DriveType as DmsDriveType;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Suiterus\Dms\Classes\DriveType;
use Suiterus\Dms\Classes\UserAccess;
use Suiterus\Dms\Models\Files\File;
use Suiterus\Dms\Models\OtherAttachments\OtherAttachments;

class FileAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $hasAccess = null;
        $fileId = null;

        if (isset($request->file_other_attachment_id)) {
            $fileId = OtherAttachments::find($request->file_other_attachment_id)->file_id;
        } else if (isset($request->file_id)) {
            $fileId = $request->file_id;
        }

        $file = File::where('id', $fileId)->first();

        $hasAccess = UserAccess::traverseFileTreeAccess($fileId, Auth::user()->roles->pluck('id'));

        if (!$hasAccess && $file->type != DmsDriveType::PUBLIC) {
            return abort(403);
        }

        return $next($request);
    }
}
