<?php

namespace App\Http\Controllers\v2\Systems;

use App\Http\Controllers\Controller;
use App\Models\AccessManagement\GroupManagement\System;
use Illuminate\Http\Request;

class SystemController extends Controller
{
    public function getSystemByNames(Request $request)
    {
        $system = System::when(isset($request->system_names) && $request->system_names != 'null' && $request->system_names != 'undefined', function ($query) use ($request) {
            $query->whereIn('name', $request->system_names);
        })->with([
            'systemModule' => function ($query) {
                $query->has('children')->with(['children.child.permission']);
            }
        ])->orderBy('name', 'ASC')->get();
        return $system;
    }

    public function show($id)
    {
        $system = System::where('id', $id)->with([
            'systemModule' => function ($query) {
                $query->has('children')->doesntHave('parents')->with(['children.child.permission']);
            }
        ])->first();
        return $system;
    }
}
