<?php

namespace App\Http\Controllers\v2\Roles;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AccessManagement\GroupManagement\ModelHasRole;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\Role;
use App\Models\AccessManagement\GroupManagement\Permission;

class RoleController extends Controller
{

    public function authModule(){
        $user = Auth::user();

        if (!$user->current_role_id) {
            return response()->json(['message' => 'User does not have a current role'], 404);
        }

        $role = Role::where('id', $user->current_role_id)->first();
        $modules = $role->roleHasSystemModule()->with(['systemModule'])->without(['roleHasPermission'])->get();
        return response()->json($modules, 200);
    }

    public function show($id)
    {
        $role = Role::where('id', $id)->without(['member'])->first();
        $permissions = $role->roleHasPermission()->with('permission')->get();
        $modules = $role->roleHasSystemModule()->without(['roleHasPermission'])->get();

        $role->member = ModelHasRole::where('role_id', $id)->get();
        
        return response()->json([
            'role' => $role,
            'permissions' => $permissions,
            'modules' => $modules
        ], 200);
    }

    public function update(Request $request)
    {
        $role = Role::where('id', $request->role['id'])->first();
        $role->update([
            'name' => $request->role['name']
        ]);

        $role->modelHasRole()->delete();
        $role->roleHasSystemModule()->delete();
        $role->roleHasPermission()->delete();

        $collectUserIds = collect($request->user_ids);

        foreach ($collectUserIds->chunk(100) as $chunkIds) {
            foreach ($chunkIds as $userId) {
                $role->modelHasRole()->updateOrCreate(
                    [
                        'role_id' => $role->id,
                        'model_type' => User::class,
                        'model_id' => $userId
                    ],
                    [
                        'role_id' => $role->id,
                        'model_type' => User::class,
                        'model_id' => $userId
                    ]
                );
            }
        }

        foreach ($request->module_ids as $moduleId) {
            $systemModule = $role->roleHasSystemModule()->updateOrCreate([
                'role_id' => $role->id,
                'system_module_id' => $moduleId
            ], [
                'role_id' => $role->id,
                'system_module_id' => $moduleId
            ]);

            $permissions = Permission::where('system_module_id', $moduleId)->get()->pluck('id')->toArray();

            foreach ($request->permission_ids as $permissionId) {
                if (in_array($permissionId, $permissions)) {
                    $role->roleHasPermission()->updateOrCreate([
                        'permission_id' => $permissionId,
                        'role_id' => $role->id,
                        'role_system_module_id' => $systemModule->id
                    ], [
                        'permission_id' => $permissionId,
                        'role_id' => $role->id,
                        'role_system_module_id' => $systemModule->id
                    ]);
                }
            }
        }

        Artisan::call('cache:clear');
    }
}
