<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class PasswordController extends Controller
{
    /**
     * Update the user's password.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|confirmed|min:6',
        ]);

        $request->user()->update([
            'password' => bcrypt($request->password),
        ]);
    }

    public function passwordValid(Request $request)
    {
        $user = User::where([
            ['id', Auth::id()],
        ])->first()->makeVisible(['password']);

        $isValid = Hash::check($request->password, $user->password);


        if (!$isValid) {
            return response()->json([
                'message' => 'Incorrect password'
            ], 404);
        }

        return response()->json([
            'message' => 'Current password matched'
        ], 200);
    }
}
