<?php

namespace App\Http\Controllers\Role;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\SwitchRoleRequest\UpdateRequest;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;

class SwitchRoleController extends Controller
{
    public function update(UpdateRequest $request)
    {
        Auth::user()->update([
            'current_role_id' => $request->role_id
        ]);
        return response()->json([
            'message' => 'Role updated successfully',
        ]);
    }
}
