<?php

namespace App\Http\Controllers\Profile;

use App\Http\Controllers\Auth\VerificationController;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ProfileContactInfoController extends VerificationController
{
    public function update(Request $req)
    {

        $valid = Validator::make($req->all(), [
            'email' => 'required|email'
        ]);

        if ($valid->fails()) {
            return response()->json([
                'message' => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();

        try {
            User::where('id', Auth::id())->update([
                'email' => $req->email,
                'email_verified_at' => null
            ]);
            
            $this->resend($req);
            
            DB::commit();
            return response()->json([
                'text' => 'Profile Contact Information has been created or updated.'
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors' => ['There is a problem in creating or updating Profile Contact Information.'],
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
