<?php

namespace App\Http\Controllers;

use App\Mail\SendDefaultEmailTemplate;
use App\Mail\SendTestEmail;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class MailController extends Controller
{
    public static function sendTestEmail(Request $request){
        $details = [
            'title' => 'Mail from Dolphins.asia',
            'body' => 'This is for testing email using smtp',
        ];
        
        try {
            return Mail::to($request->email_to)->send(new SendTestEmail($details));
        } catch (Exception $e) {
            return response()->json([
                'message' => 'Error encountered, please make sure that your configuration is correct.',
                'error' => $e->getMessage()
            ], 400);
        }

    }

    public static function sendCredentials($name, $email, $password){

        $details = [
            'name' => $name,
            'email' => $email,
            'password' => $password,
            'login_url' => env('CLIENT_URL'),
            'name' => str_replace('_', ' ', env('MAIL_FROM_NAME') ?? "Dolphins Software")
        ];
        
        try {
            return Mail::to($email)->send(new SendDefaultEmailTemplate($details));
        } catch (Exception $e) {
            return response()->json([
                'message' => 'Error encountered, please make sure that your configuration is correct.',
                'error' => $e->getMessage()
            ], 400);
        }

    }

    public static function sendDefaultEmailTemplate(Request $request){

        $details = [
            'title' => 'Mail from Dolphins.asia',
            'body' => 'This is for testing email using smtp',
            'name' => str_replace('_', ' ', env('MAIL_FROM_NAME') ?? "Dolphins Software")
        ];
       
        try {
            return Mail::to($request->email_to)->send(new SendDefaultEmailTemplate($details));
        } catch (Exception $e) {
            return response()->json([
                'message' => 'Error encountered, please make sure that your configuration is correct.',
                'error' => $e->getMessage()
            ], 400);
        }

    }
}
