<?php

namespace App\Http\Controllers;

use Activity;
use Illuminate\Http\Request;


class DocumentLogController extends Controller
{
    public function paginate(Request $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return config('activitylog.custom_activity_models')[$request->activity_type ?? 'dms']::when($request->search, function ($query) use ($request) {
            $query->orWhere('log_name', 'LIKE', '%' . $request->search . '%')->orWhere('type', 'LIKE', '%' . $request->search . '%')->orWhere('description', 'LIKE', '%' . $request->search . '%');
        })->when($request->userName, function ($query) use ($request) {
            $query->whereHas('causer', function ($query) use ($request) {
                $query->where('name', 'LIKE', '%' . $request->userName . '%');
            });
        })->when($request->activity, function ($query) use ($request) {
            $query->where('type', $request->activity);
        })->when($request->dates, function ($query) use ($request) {
            if (count($request->dates) == 2) {
                $query->whereBetween('created_at', $request->dates);
            } else if (count($request->dates) == 1) {
                $query->whereDate('created_at', $request->dates[0]);
            }
        })->with(['causer', 'subject'])->latest()->paginate($paginate);
    }

    public function fetchLogType(Request $request)
    {
        return config('activitylog.custom_activity_models')[$request->activity_type ?? 'dms']::select('type')->distinct()->get();
    }
}
