<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Models\Systems\Notification;
use App\Events\Notifications;
use Illuminate\Http\Request;
use App\Models\User;
use Exception;
use Validator;
use Auth;
use DB;

class Controller extends BaseController
{

    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    //create notification globally
    public function createNotif($title, $message, $type, $to = []){
        DB::beginTransaction();
        try{
            $n = Notification::create([
                'title'     =>  $title,
                'message'   =>  $message,
                'from'      =>  $type === 'information' ? User::find(1)->id : Auth::user()->id,
                'type'      =>  $type,
            ]);
            //notify the developer
            if(Auth::user()->id !== 2){
                $to[] = User::findOrFail(2);
            }
            foreach($to as $t){
                $n->to()->create([
                    'user_id'   =>  $t->id
                ]);
            }
            broadcast(new Notifications($n));
            DB::commit();
            return true;
        }catch(Exception $e){
            DB::rollback();
            return ('You cant create a notification yet. Please contact us to fix it.');
        }
    }

    public function updateDarkMode(Request $req){
        $user = $req->user();
        $user->isDark = $req->isDark;
        $user->save();
        return "updated";
    }

}
