<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Enums\Status;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\UserSupervisors\Supervisors;

class CommonController extends Controller
{
    // Employees
    public function employees() {
        return response()->json([
            'data' => User::select('id', 'name', 'email')->has('employeeMetaInfo')->where('status', Status::ACTIVE)->without([
                'currentRole',
                'roles',
                'permissions',
                'storage',
                'supervisor',
                'user_supervisor',
                'exitInterview',
                'userProfilePicture',
                'profileBasicInfo'
            ])->with([
                'employeeMetaInfo' => function ($query) {
                    $query->select('id', 'user_id', 'employee_id')->without([
                        'corporation',
                        'branch',
                        'division',
                        'department',
                        'employeeType',
                        'position',
                        'itemCode'
                    ]);
                }
            ])->get()
        ]);
    }

    // Branches
    public function branches() {
        return response()->json([
            'data'  => Branch::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Corporations
    public function corporations() {
        return response()->json([
            'data'  => Corporation::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Divisions
    public function divisions() {
        return response()->json([
            'data'  => Division::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Departments
    public function departments() {
        return response()->json([
            'data'  => Department::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Sections
    public function sections() {
        return response()->json([
            'data'  => Section::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Units
    public function units() {
        return response()->json([
            'data'  => Unit::where('status', Status::ACTIVE)->get()
        ]);
    }

    // Supervisors
    public function supervisors() {
        return response()->json([
            'data'  => Supervisors::with(['user' => function($query) {
                    $query->without(['roles', 'storage', 'permissions'])
                        ->with(['employeeMetaInfo' => function ($query) {
                            $query->without('branch', 'corporation', 'division', 'department', 'position')
                                ->select('user_id', 'employee_id');
                        }]);
                }])->get()
        ]);
    }

    // Positions
    public function positions() {
        return response()->json([
            'data'  => Position::all()
        ]);
    }

    // Employee Types
    public function employeeTypes() {
        return response()->json([
            'data'  => EmployeeType::all()
        ]);
    }

}
