<?php

namespace App\Http\Controllers\AccessManagement\GroupManagement;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function fetch(){
        return User::select('id', 'name')->without(['roles', 'permissions', 'supervisor', 'employeeMetaInfo', 'storage'])->get();
    }

    public function fetchSignatory()
    {
        return User::select('id', 'name')->where('id', '!=', Auth::id())->whereHas('license', function($query){
            $query->where([
                ['e_signature', '!=', null],
                ['blur_e_signature', '!=', null],
            ]);
        })->without(['roles', 'permissions', 'supervisor', 'employeeMetaInfo', 'storage'])->get();
    }

    public function fetchCandidateLeader(Request $request){
        return User::whereHas('roles', function($query) use($request) {
            $query->where('role_id', $request->role_id);
        })->get();
    }

    public function fetchRoleMember(Request $request)
    {
        $users = User::whereHas('roles', function($query) use($request) {
            $query->where('id', $request->role_id);
        })->get();

        return $users;
    }
}
