<?php

namespace App\Http\Controllers\AccessManagement\GroupManagement;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class SystemModuleController extends Controller
{
    public function create(Request $request){
        $valid = Validator::make($request->all(),[
            'name'  =>  'required|string|unique:'.env('DB_CONNECTION').'.system_modules,name',
            'system_id' => 'required|exists:'.env('DB_CONNECTION').'.systems,id'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
           
            SystemModule::create([
                'name' => $request->name,
                'system_id' => $request->system_id
            ]);
            
            DB::commit();
            return response()->json([
                'text'  =>  'System module has been created.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in creating new Role.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function update(Request $request){
        $valid = Validator::make($request->all(),[
            'id'  =>  'required|exists:'.env('DB_CONNECTION').'.system_modules,id',
            'name' => 'required|string'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
           
            SystemModule::where('id', $request->id)->update([
                'name' => $request->name
            ]);
            
            DB::commit();
            return response()->json([
                'text'  =>  'System module has been updated.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in creating new Role.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete(Request $request){
        $valid = Validator::make($request->all(),[
            'id'  =>  'required|exists:'.env('DB_CONNECTION').'.system_modules,id',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
           
            SystemModule::where('id', $request->id)->delete();
            
            DB::commit();
            return response()->json([
                'text'  =>  'System module has been deleted.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in creating new Role.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function fetch(Request $request){
        return SystemModule::when($request->system_id, function($query) use($request) {
            $query->where('system_id', $request->system_id);
        })->get();
    }

    public function paginate(Request $request){
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return SystemModule::when($request->system_id, function($query) use($request) {
            $query->where('system_id', $request->system_id);
        })->paginate($paginate);
    }
}
