<?php

namespace App\Http\Controllers\AccessManagement\GroupManagement;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Models\AccessManagement\GroupManagement\System;

class SystemController extends Controller
{
    public function create(Request $request){
        $valid = Validator::make($request->all(),[
            'name'  =>  'required|string|unique:'.env('DB_CONNECTION').'.systems,name'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{

            System::create([
                'name' => $request->name
            ]);

            DB::commit();
            return response()->json([
                'text'  =>  'System has been created.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in creating new Role.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete(Request $request){
        $valid = Validator::make($request->all(), [
            'id' => 'required|exists:'.env('DB_CONNECTION').'.systems,id'
        ]);

        if ($valid->fails()) {
            return response()->json([
                $valid->errors()
            ], 400);
        }
        try {
            System::where('id', $request->id)->delete();
            return response()->json([
                'message' => 'System is deleted'
            ], 200);
        } catch (\Throwable $th) {
            return $th;
        }
    }

    public function update(Request $request){
        $valid = Validator::make($request->all(),[
            'id' => 'required|exists:'.env('DB_CONNECTION').'.systems,id',
            'name' => 'required'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{

            System::where('id', $request->id)->update([
                'name' => $request->name
            ]);

            DB::commit();
            return response()->json([
                'text'  =>  'System has been updated.'
            ]);
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in creating role leader.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function paginate(Request $request){
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return System::paginate($paginate);
    }

    public function fetch(){
        return System::with(['systemModule'])->get();
    }
}
