<?php

namespace App\Http\Controllers\AccessManagement\GroupManagement;

use App\Models\AccessManagement\GroupManagement\RoleHasPermission;
use App\Models\AccessManagement\GroupManagement\RoleHasSystemModule;
use App\Models\AccessManagement\GroupManagement\SubRole;
use Illuminate\Http\Request;

class SubRoleModuleController extends SubRoleController
{
    public function fetchModule(Request $request)
    {
        $subrole = SubRole::where('sub_role_id', $request->sub_role_id)->first();
        if ($subrole) {
            $parentRoleId = $subrole->parent_role_id;
            $parentRoleModule = RoleHasSystemModule::where('role_id', $parentRoleId)->with(['systemModule', 'roleHasPermission.permission'])->get();
            $enabledSubRoleModules = RoleHasSystemModule::where('role_id', $request->sub_role_id)->with(['systemModule', 'roleHasPermission.permission'])->get();

            return response()->json([
                'parent_role_module' => $parentRoleModule,
                'sub_role_module' => $enabledSubRoleModules
            ]);
        }
    }
}
