<?php
namespace App\Http\Classes;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Systems\NotificationController;
use App\Models\Notifications\NotificationMessages;
use Suiterus\Adg\Models\SM\ScheduleType;

class NotificationMessage extends Notification {
    public static function notifySenderAndReceiver($header, $receiverID, $senderID, $userApprover = null, $forwardId = null, $fileSignatorySigneeID = null, $applicantName = null, $customMessage = null){
        $notificationMessages = NotificationMessages::where('header', $header)->first();
        $notifySender = [
            "notification_id" => $notificationMessages->id,
            "send_to" => 'sender',
            "sender_id" => $receiverID,
            "receiver_id" => $senderID
        ];
        $notifyReceiver = [
            "notification_id" => $notificationMessages->id,
            "send_to" => 'receiver',
            "sender_id" => $senderID,
            "receiver_id" => $receiverID
        ];  

        if ($userApprover) {
            $notifySender['user_approver_id'] = $userApprover;
            $notifyReceiver['user_approver_id'] = $userApprover;
        }

        if($forwardId){
            $notifySender['forward_id'] = $forwardId;
            $notifyReceiver['forward_id'] = $forwardId;
        }

        if ($fileSignatorySigneeID) {
            $notifySender['file_signatory_signee_id'] = $fileSignatorySigneeID;
            $notifyReceiver['file_signatory_signee_id'] = $fileSignatorySigneeID;
        }

        if ($applicantName) {
            $notifySender['applicant_name'] = $applicantName;
            $notifyReceiver['applicant_name'] = $applicantName;
        }
        
        if ($customMessage) {
            $notifySender['custom_message'] = $customMessage;
            $notifyReceiver['custom_message'] = $customMessage;
        }

        NotificationController::sendNotification($notifySender);
        NotificationController::sendNotification($notifyReceiver);
    }
    public static function notifyReceiver($header, $receiverID, $senderID, $userApprover = null, $forwardId = null, $fileSignatorySigneeID = null, $applicantName = null, $customMessage = null){
        $notificationMessages = NotificationMessages::where('header', $header)->first();
        $notifyReceiver = [
            "notification_id" => $notificationMessages->id,
            "send_to" => 'receiver',
            "sender_id" => $senderID,
            "receiver_id" => $receiverID 
        ];

        if ($userApprover) {
            $notifySender['user_approver_id'] = $userApprover;
            $notifyReceiver['user_approver_id'] = $userApprover;
        }

        if($forwardId){
            $notifySender['forward_id'] = $forwardId;
            $notifyReceiver['forward_id'] = $forwardId;
        }

        if ($fileSignatorySigneeID) {
            $notifySender['file_signatory_signee_id'] = $fileSignatorySigneeID;
            $notifyReceiver['file_signatory_signee_id'] = $fileSignatorySigneeID;
        }
        
        if ($applicantName) {
            $notifyReceiver['applicant_name'] = $applicantName;
        }
        
        if ($customMessage) {
            $notifyReceiver['custom_message'] = $customMessage;
        }
        
        NotificationController::sendNotification($notifyReceiver);
    }
}